#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INF = (ll)1e18;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<ll> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    // ????????? ?? x ??????????
    vector<int> p(n);
    iota(p.begin(), p.end(), 0);
    sort(p.begin(), p.end(), [&](int a, int b) {
        return x[a] < x[b];
    });

    vector<ll> xs(n), hs(n);
    for (int i = 0; i < n; i++) {
        xs[i] = x[p[i]];
        hs[i] = h[p[i]];
    }

    vector<ll> best(n, INF);

    // ??????? ?? ?????????
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (hs[j] >= hs[i]) {
                ll dist = abs(xs[i] - xs[j]);
                best[i] = min(best[i], dist);
            }
        }
    }

    // ??????? ?? ???????
    for (int i = 0; i + 1 < n; i++) {
        ll x1 = xs[i], h1 = hs[i];
        ll x2 = xs[i + 1], h2 = hs[i + 1];

        ll mid = (x1 + x2 + h2 - h1) / 2; // ????? ??????? ??????
        ll maxH = max(h1, h2);

        for (int j = 0; j < n; j++) {
            if (hs[j] <= maxH) {
                ll dx = abs(xs[j] - mid);
                ll dy = maxH - hs[j];
                best[j] = min(best[j], dx + dy);
            }
        }
    }

    // ??????? ???????? ? ?????????? ????????
    vector<ll> ans(n, -1);
    for (int i = 0; i < n; i++) {
        if (best[i] != INF) ans[p[i]] = best[i];
    }

    for (int i = 0; i < n; i++) {
        cout << ans[i] << "\n";
    }

    return 0;
}